package com.example.bottomsheetcompose

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material.MaterialTheme
import androidx.compose.material.Surface
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.platform.LocalView
import androidx.compose.ui.platform.rememberNestedScrollInteropConnection
import androidx.compose.ui.tooling.preview.Preview
import com.example.bottomsheetcompose.databinding.ActivityMainBinding
import com.example.bottomsheetcompose.ui.theme.BottomSheetComposeTheme
import com.google.android.material.bottomsheet.BottomSheetBehavior

@OptIn(ExperimentalComposeUiApi::class)
class MainActivity : ComponentActivity() {
	override fun onCreate(savedInstanceState: Bundle?) {
		super.onCreate(savedInstanceState)

		val binding = ActivityMainBinding.inflate(layoutInflater)
		setContentView(binding.root)

		val behavior = BottomSheetBehavior.from(binding.bottomSheet)
		behavior.peekHeight = 600

		binding.composeContent.setContent {
			val googleNestedScrollConnection = rememberNestedScrollInteropConnection()
			BottomSheetComposeTheme {
				LazyColumn(
					Modifier
						.nestedScroll(googleNestedScrollConnection)
						.fillMaxSize()
				) {
					items(100) {
						Text("Item $it", Modifier.fillMaxWidth(), Color.Black)
					}
				}
			}
		}
	}
}